import argparse
from ACState.object_dict import ObjDict
from Hyperparam.read_config import read_config
import numpy as np
import os

def get_args():
    args = ObjDict()
    parser = argparse.ArgumentParser(description='Construct an environment')
    parser.add_argument('--config', default="",
                        help='config file to read for hyperparameters')
    args = parser.parse_args()

    config = args.config
    args = read_config(args.config)
    args.config_name = os.path.split(config)[1][:-5]
    return args